#include <stdint.h>

/* ----------------- Example code from MISRA C:2012 begin ----------------- */

int32_t f1 ( int32_t * const a1, int32_t a2[ 10 ] )
{
  int32_t *p = &a1[ 3 ];

  return *( a2 + 9 );           /* Compliant     */
}

void f2 ( void )
{
  int32_t data = 0;
  int32_t b = 0;
  int32_t c[ 10 ] = { 0 };
  int32_t d[ 5 ][ 2 ] = { 0 };

  int32_t *p1 = &c[ 0 ];        /* Compliant     */
  int32_t *p2 = &c[ 10 ];       /* Compliant     */
  int32_t *p3 = &c[ 11 ];       /* Non-compliant */

  data = *p2;                   /* Non-compliant */
  data = f1 ( &b, c );          /* Non-compliant */
  data = f1 ( c, c );           /* Compliant     */

  p1++;                         /* Compliant     */
  c[ -1 ] = 0;                  /* Non-compliant */
  data = c[ 10 ];               /* Non-compliant */
  data = *( &data + 0 );        /* Compliant     */

  d[ 3 ][ 1 ] = 0;              /* Compliant     */
  data = *( *( d + 3 ) + 1 );   /* Compliant     */
  data = d[ 2 ][ 3 ];           /* Non-compliant */

  p1 = d[ 1 ];                  /* Compliant     */
  data = p1[ 1 ];               /* Compliant     */
}

struct
{
  uint16_t x;
  uint16_t y;
  uint16_t z;
  uint16_t a[ 10 ];
} s;

uint16_t *p;

void f3 ( void )
{
  p = &s.x;
  ++p;                          /* Compliant     */
  p[ 0 ] = 1;                   /* Non-compliant */
  p[ 1 ] = 2;                   /* Non-compliant */

  p = &s.a[ 0 ];                /* Compliant     */
  p = p + 8;                    /* Compliant     */
  p = p + 3;                    /* Non-compliant */
}

/* ------------------ Example code from MISRA C:2012 end ------------------ */
